import pytest
from unittest.mock import Mock, patch

from webcount import most_common_word_in_web_page, most_common_word

def test_most_common_word():
    assert most_common_word(['a', 'b', 'c'], 'abbbcc') == 'b', 'most_common_word with unique asnwer'

def test_most_common_word_empty_candidate():
    from pytest import raises
    with raises(Exception):
        most_common_word([], 'abc')

def test_most_common_ambiguous_result():
    assert most_common_word(['a', 'b', 'c'], 'ab') in ('a', 'b'), "there might be a tie"

@pytest.mark.skip("Do not run this")
def test_with_patch():
    mock_requests = Mock()
    mock_requests.get.return_value.text = 'aa bbb c'
    with patch('webcount.functions.requests', mock_requests):
        result = most_common_word_in_web_page(
            ['a', 'b', 'c'],
            'https://python.org/'
        )
    assert result == 'b', \
        'most_common_word_in_web_page tested with test double'
    assert mock_requests.get.call_count == 1
    assert mock_requests.get.call_args[0][0] \
            == 'https://python.org/', 'called with right URL'


def test_with_test_double(): 
    class TestResponse(): 
        text = 'aa bbb c'

    class TestUserAgent(): 
        def get(self, url):
            return TestResponse()

    result = most_common_word_in_web_page(['a', 'b', 'c'], 
        'https://python.org/',
        user_agent=TestUserAgent())

    assert result == 'b', 'most_common_word_in_web_page tested with test double'


def test_with_test_double2(): 
    class TestResponse(): 
        text = 'aa bbb c'

    class TestUserAgent(): 
        def get(self, url):
            self.url = url
            return TestResponse()

    test_ua = TestUserAgent()
    result = most_common_word_in_web_page(['a', 'b', 'c'], 
        'https://python.org/',
        user_agent=test_ua)

    assert result == 'b', 'most_common_word_in_web_page tested with test double'
